;****************************************************
;
;         JTV IRC Channel Control Script v 1.1
;          Auto-update Stand-alone Script
;                2011 Jennifer Snow
;
;****************************************************
;
;  The JTV IRC Channel Control Script was created to
;  allow JTV broadcasters who wish to use the IRC 
;  interface an easy to use interface to the dot and
;  slash commands available on jtv's irc server.
;
;****************************************************
;
;  Feedback is always welcomed, and right now is 
;  being requested for more features/bugfixing.
;
;****************************************************
;
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.
;  
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
;  
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;****************************************************

;*********************
; DLL/MDX Aliases
;*********************
;
; These also have an advantage... the jtvirc.loaddll function checks
;   that the dll is actually present, and returns an error if it is not.

alias jtvirc.munzip { return $jtvirc.getdll(mUnzip.dll,16,jtvirc.aliases.mrc) }
alias jtvirc.mdx { return $jtvirc.getdll(mdx.dll,17,jtvirc.aliases.mrc) }

;*************************************
; InstallUpdate
;*************************************
;
; We need to make sure the script we are updating
; is unloaded entirely.  We make sure of this statically, 
; as this is not intended for widespread use.  Maybe I will
; implement that in a future "updater" version... I dunno.
;

alias jtvirc.installupdate {

  if ( %jtvirc.DebugWindow == true ) {
    set %jtvirc.DebugWindowTmp true
    jtvirc.Display 6 Unloading JTV IRC for update to $+(v,$1)
  }

  ; make sure our jtvirc script is unloaded entirely
  .unload -rs $+(",$scriptdir,jtvirc.mrc,")

  if ( %jtvirc.DebugWindowTmp == true ) {
    jtvirc.Display 6 Updating JTV IRC to $+(v,$1) ...
  }

  ; now, we need to unzip the downloaded file. Passed as $2
  jtvirc.unzip $1 $+(",$2-,")
}

;*********************
; Unzip interface
;*********************
alias jtvirc.unzip {
  ; Unzip everything to a temp directory so that we can copy and unload DLLs correctly.
  var %retval = $dll($jtvirc.munzip,Unzip,-do $2- $+(",$scriptdir,tmp,"))
  if (S_OK* !iswm  %retval) {
    jtvirc.displayerror $scriptline jtvirc.update.mrc Error in autoupdate: %retval
  }
  else {
    
    ; update unzipped.  Unload all dlls used by jtvirc
    jtvirc.unloaddll mUnzip.dll
    jtvirc.unloaddll mdx.dll

    ; get the total number of files in the update
    var %jtvirc.x = $findfile($+(",$scriptdirtmp,"),*.*,0,4)
    
    ; iterate through the files, moving each to the working dir
    while ( %jtvirc.x > 0 ) {
    
      ; Get the path of the file, relative to scriptdir\tmp
      var %jtvirc.relativeFilePath = $remove($findfile($scriptdirtmp,*.*,%jtvirc.x),$scriptdirtmp\jtvirc\)

      ; make sure the file exists first 
      if $isfile($+(",$scriptdirtmp\jtvirc\,%jtvirc.relativeFilePath,")) { 

        ; Copy the file from the tmp dir to the working directory, overwriting by default
        ; skip mdx.dll, as it does not unload properly, and we wont be upgrading it anyway
        ; Doing it this way allows us to keep MDX.dll in the zipfile for new users, and still
        ; prevent the error it will cause if we try to overwrite it.
        if (( *mdx.dll !iswm %jtvirc.relativeFilePath ) && ( *mUnzip.dll !iswm %jtvirc.relativeFilePath )) {
          if ( %jtvirc.DebugWindowTmp == true ) {
            jtvirc.Display 6 Copying $+(",$scriptdirtmp\jtvirc\,%jtvirc.relativeFilePath,") to $+(",$scriptdir,%jtvirc.relativeFilePath,")
          }
          .copy -o $+(",$scriptdirtmp\jtvirc\,%jtvirc.relativeFilePath,") $+(",$scriptdir,%jtvirc.relativeFilePath,")
        }

        ; Delete the tempfile
        if ( %jtvirc.DebugWindowTmp == true ) {
          jtvirc.Display 6 Deleting $+(",$scriptdirtmp\jtvirc\,%jtvirc.relativeFilePath,")
        }
        .remove -b $+(",$scriptdirtmp\jtvirc\,%jtvirc.relativeFilePath,")
      }

      ; move to the next file
      dec %jtvirc.x
    }

    ; now delete the tmp folder and its subfolders
    var %jtvirc.dirs = $finddir($scriptdirtmp,*.*,0,4)
    while ( %jtvirc.dirs > 0 ) {
      if ( %jtvirc.DebugWindowTmp == true ) {
        jtvirc.Display 6 Deleting $+(",$finddir($scriptdirtmp,*.*, %jtvirc.dirs ,4),") directory
      }
      .rmdir $+(",$finddir($scriptdirtmp,*.*, %jtvirc.dirs ,4),")
      dec %jtvirc.dirs
    }

    if ( %jtvirc.DebugWindowTmp == true ) {
      jtvirc.Display 6 Deleting $scriptdirtmp directory
    }
    .rmdir $scriptdirtmp

    ;delete the zipfile we downloaded
    if ( %jtvirc.DebugWindowTmp == true ) {
      jtvirc.Display 6 Deleting $2-
    }
    .remove -b $2-
    
    ; Now reload the main script
    if ( %jtvirc.DebugWindowTmp == true ) {
      jtvirc.Display 6 JTV IRC updated to $+(v,$1). Reloading JTV IRC
    }
    .load -rs $+(",$scriptdir,jtvirc.mrc,")

    ; and unload ourself
    if ( %jtvirc.DebugWindowTmp == true ) {
      jtvirc.Display 6 Unloading JTV IRC Update Script
    }
    .unload -rs $+(",$scriptdir,jtvirc.update.mrc,")
  }
}

;*********************
; DLL Pathing routine
;*********************
alias -l jtvirc.getdll {
  if (!$isfile($+($scriptdir,dlls\,$1))) {
    jtvirc.displayerror $2 $3- File Not Found: $1
  }
  else {
    return $+(",$scriptdir,dlls\,$1,")
  }
}

;*********************
; DLL Release
;*********************
alias jtvirc.unloaddll {
  dll -u $1-
}

;*********************
; Message display
;*********************
alias jtvirc.Display {
  ; if the window was shut, reopen it to display messages
  if ( $window(@jtvirc.Messages) != @jtvirc.Messages ) {
    .window -exzk0 +eltx @jtvirc.Messages 
  }    
  .aline $1 @jtvirc.Messages *** $2- 
}

;*********************
; Error display
;*********************
alias jtvirc.displayerror { 
  if ( %jtvirc.DebugWindowTmp == true ) {
    jtvirc.Display 4 JTV IRC script halted. $3- (Line $1 in file $2 $+ )
  } 
  else {
    echo 4 -st *** JTV IRC script halted. $3- (Line $1 in file $2 $+)
  }

  if ($dialog(jtvirc.main)) dialog -x jtvirc.main

  if ($dialog(0) > 0) {
    var %y = $dialog(0)
    while (%y > 0) { 
      dialog -x $dialog(%y) 
      dec %y
    }
  }
  halt
}
