;****************************************************
;
;         JTV IRC Channel Control Script v 1.1
;                Main Control Script
;                ©2011 Jennifer Snow
;
;****************************************************
;
;  The JTV IRC Channel Control Script was created to
;  allow JTV broadcasters who wish to use the IRC 
;  interface an easy to use interface to the dot and
;  slash commands available on jtv's irc server.
;
;****************************************************
;
;  Feedback is always welcomed, and right now is 
;  being requested for more features/bugfixing.
;
;****************************************************
;
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.
;  
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
;  
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;****************************************************
;  Version history
;
;  v1.1 - 12/28/2011
;    - Second release - added features to dialog
;    - some bugs found
;
;  v1.0 - 10/23/2011
;    - Initial compilation. First mIRC release
;
;  Known issues/bugs:
;
;    - a few of the random kick/ban messages are 
;      flawed and do not display correctly
;
;    - The timeout and ban/unban boxes have a hard
;      limit for name entry - do not know why this
;      is the case at present.
;
;    - Channel name in dialog requires # as first
;      character.
;
;  Planned for next version:
;
;    - More commercial run options
;    - Vote Script
;    - Better kick messages/messaging
;    - Better help system
;    - Actual webpage for initial install/config
;
;****************************************************
;

menu nicklist,channel,status,menubar,chat,query {
  -
  JTV IRC v $+ %jtvirc.version:jtvirc.dlg jtvirc.main jtvirc.main 47 jtvirc.mrc
}

;*************************************
; Script initialization
;*************************************
on 1:LOAD: {
  ;make sure our helper scripts are loaded as well
  .load -rs $+(",$scriptdir,jtvirc.commands.mrc,")
  .load -rs $+(",$scriptdir,jtvirc.dialogs.mrc,")
  .load -rs $+(",$scriptdir,jtvirc.events.mrc,")
  .load -rs $+(",$scriptdir,jtvirc.autoupdate.mrc,")
}

on 1:START: {
  ;set up our running variables
  jtvirc.setvars
  jtvirc.loadhashtable

  ; All our hash table data is loaded.  We can start checking
  ; user preferences now.

  ; open @jtvirc.Messages custom window if user wants msg's displayed
  if ($jtvirc.hash(debugwindow).get == 1) {
    set %jtvirc.DebugWindow true
    .window -exzk0 +eltx @jtvirc.Messages 
    jtvirc.Display 6 jtvIRC v $+ %jtvirc.version loaded.
  }

  ; If the user wants to auto-update, check for updates.
  if ($jtvirc.hash(autoupdate).get == 1) {
    jtvirc.checkversion
  }
}

;*************************************
; Script de-initialization
;*************************************
on 1:UNLOAD: {
  ;save our hashtable
  jtvirc.savehashtable

  ;remove any leftover vars
  unset %jtvirc.*

  ;free the hashtable
  hfree jtvirc.hashtable

  ;and unload all helper scripts
  .unload -rs $+(",$scriptdir,jtvirc.autoupdate.mrc,")
  .unload -rs $+(",$scriptdir,jtvirc.commands.mrc,")
  .unload -rs $+(",$scriptdir,jtvirc.dialogs.mrc,")
  .unload -rs $+(",$scriptdir,jtvirc.events.mrc,")

  if (%mIRCSplit.DebugWindow) {
    jtvirc.Display 6 jtvirc unloaded.
  }
}

;*************************************
; Catching viewer count from JTV
;*************************************

on ^*:TEXT:*from embeds*:?: {
  if ($nick == jtv) {
    /msg $jtvirc.hash(channel) $1-
  }
}

;*************************************
; Catching topic request from JTV
;*************************************
on ^*:TEXT:!topic:#: {
  if ($chan == $jtvirc.hash(channel)) {
    /msg $jtvirc.hash(channel) $jtvirc.hash(title)
  }
}

;*************************************
; Random timeout function
;*************************************

alias jtvirc.RandomTOStatement {
  ; select random statement
  set %kickRand $rand(1,32)

  if (%kickRand == 1) { /msg $jtvirc.hash(channel) Silence %jtvirc.UserTOd $+ ! | .timer 1 3 /msg $jtvirc.hash(channel) Iiiii | .timer 1 6 /msg $jtvirc.hash(channel) Keeeel | .timer 1 9 /msg $jtvirc.hash(channel) Yoooooooh!!! | .timer 1 12 /msg $jtvirc.hash(channel) R) }
  if (%kickRand == 2) { /msg $jtvirc.hash(channel) If You Smelllllllllllll | .timer 1 3 /msg $jtvirc.hash(channel) What The Cat | .timer 1 6 /msg $jtvirc.hash(channel) Isssssss | .timer 1 9 /msg $jtvirc.hash(channel) Cookin...... }
  if (%kickRand == 3) { /msg $jtvirc.hash(channel) Hi ho Hi ho..... | .timer 1 6 /msg $jtvirc.hash(channel) It's out the door you goooooo }
  if (%kickRand == 4) { /msg $jtvirc.hash(channel) When theres something straaaaaange | .timer 1 3 /msg $jtvirc.hash(channel) In da neighbourhooooood | .timer 1 6 /msg $jtvirc.hash(channel) Who ya gonna call? | .timer 1 9 /msg $jtvirc.hash(channel) Tardbusters!!!!!!!! }
  if (%kickRand == 5) { /msg $jtvirc.hash(channel) %jtvirc.UserTOd $+ !!!!! | .timer 1 3 say Someday, somebody, somewhere will love you..... | .timer 1 6 But for now.....fuck off }
  if (%kickRand == 6) { /msg $jtvirc.hash(channel) %jtvirc.UserTOd Quit Your Jibber Jabber | .timer 1 3 say And stop actin like a crazy fool..... | .timer 1 6 say Or your gonna meet my friend paaaaaaaain... }
  if (%kickRand == 7) { /action $jtvirc.hash(channel) gives %jtvirc.UserTOd a lotto ticket.... | .timer 1 3 /action $jtvirc.hash(channel) checks %jtvirc.UserTOd $+ 's number against the numbers drawn.... | .timer 1 6 say Wow...you won an ass kickin!!! Congratulations!! }
  if (%kickRand == 8) { /msg $jtvirc.hash(channel) Somewheeeeeeeeeere | .timer 1 3 say Ooooooooover the raaaaaaaainboooooooooow | .timer 1 6 say I fuuuuuuucked you uuuuuupppppppp..... }
  if (%kickRand == 9) { /msg $jtvirc.hash(channel) Cat Takes Aim.... She Shoots..... She Scooooooores!!! Cats goin t da supabowl!!!!! }
  if (%kickRand == 10) { /msg $jtvirc.hash(channel) I know theres one born every minute...but daaaaayuum you is a fool! }
  if (%kickRand == 11) { /msg $jtvirc.hash(channel) Sometimes  in life, %jtvirc.UserTOd $+ , the truth is better being kept from you, so I'll lie and say this kick was an accident :/ }
  if (%kickRand == 12) { /msg $jtvirc.hash(channel) The problem with the gene pool is that there is no lifeguard. }
  if (%kickRand == 13) { /msg $jtvirc.hash(channel) The only substitute for good manners is fast reflexes. }
  if (%kickRand == 14) { /msg $jtvirc.hash(channel) Never test the depth of the water with both feet. }
  if (%kickRand == 15) { /msg $jtvirc.hash(channel) Learn from your parents' mistakes: use birth control. }
  if (%kickRand == 16) { /msg $jtvirc.hash(channel) I just got lost in thought. It was unfamiliar territory. }
  if (%kickRand == 17) { /msg $jtvirc.hash(channel) Artificial Intelligence usually beats real stupidity. }
  if (%kickRand == 18) { /msg $jtvirc.hash(channel) 100,000 sperm and you were the fastest? }
  if (%kickRand == 19) { /msg $jtvirc.hash(channel) Always remember you're unique - just like everyone else. }
  if (%kickRand == 20) { /msg $jtvirc.hash(channel) Genius does what it must, talent does what it can, and you had best do what you're told. }
  if (%kickRand == 21) { /msg $jtvirc.hash(channel) You get enough exercise just pushing your luck. }
  if (%kickRand == 22) { /msg $jtvirc.hash(channel) Never miss a good chance to shut the fuck up. }
  if (%kickRand == 23) { /msg $jtvirc.hash(channel) Never underestimate the power of stupid people in large groups. }
  if (%kickRand == 24) { /msg $jtvirc.hash(channel) Some people are only alive because it is illegal to shoot them. }
  if (%kickRand == 25) { /msg $jtvirc.hash(channel) The problem with the gene pool is that there is no lifeguard. }
  if (%kickRand == 26) { /msg $jtvirc.hash(channel) You have the right to remain silent. Anything you /msg $jtvirc.hash(channel) will be misquoted then used against you. }
  if (%kickRand == 27) { /msg $jtvirc.hash(channel) If I wanted any lip from you, I'd rattle my zipper. }
  if (%kickRand == 28) { /msg $jtvirc.hash(channel) You don't just know anything, you don't even suspect much. }
  if (%kickRand == 29) { /msg $jtvirc.hash(channel) You look as confused as a blind lesbian in a fish market. }
  if (%kickRand == 30) { /msg $jtvirc.hash(channel) I'm Bruce Willis Man! Yippee-Ki-Yay MuthaFucka!!. }
  if (%kickRand == 31) { /msg $jtvirc.hash(channel) I'm Charlie Murphy Bitch!! }
  if (%kickRand == 32) { /msg $jtvirc.hash(channel) I'm Rick James Bitch!! }
}

;*************************************
; Nicklist commands (op, ban, etc)
;*************************************

menu nicklist {
  -
  JTV Commands
  .Op:if ($me isop $jtvirc.hash(channel)) { /msg $jtvirc.hash(channel)) .op $1 }
  .DeOp:if ($me isop $jtvirc.hash(channel)) { /msg $jtvirc.hash(channel)) .unop $1 }
  .-
  .Timeout:if ($me isop $jtvirc.hash(channel)) { /msg $jtvirc.hash(channel)) .timeout $1 $?="Seconds to timeout $1 for?" | set %jtvirc.UserTOd $1 | $jtvirc.RandomTOStatement | /msg $jtvirc.hash(channel) $1 timed out. }
  .Ban:if ($me isop $jtvirc.hash(channel)) { /msg $jtvirc.hash(channel)) .ban $1 | set %jtvirc.UserTOd $1 | $jtvirc.RandomTOStatement | /msg $jtvirc.hash(channel) $1 banhammered. }
  .Unban:if ($me isop $jtvirc.hash(channel)) { /msg $jtvirc.hash(channel)) .unban $1 | /msg $jtvirc.hash(channel) $1 unbanned. }
}


;*************************************
; JTV Emoticons
;*************************************
; Create our menu options
menu channel,chat {
  -
  JTV Emoticons
  .StoneLightning:/msg $chan StoneLightning 
  .TheRinger:/msg $chan TheRinger
  .RedCoat:/msg $chan RedCoat
  .OptimizePrime:/msg $chan OptimizePrime
  .JKanStyle:/msg $chan JKanStyle
  .CougarHunt:/msg $chan CougarHunt
  .EagleEye:/msg $chan EagleEye
  .BrokeBack:/msg $chan BrokeBack
  .PazPazowitz:/msg $chan PazPazowitz
  .Kappa:/msg $chan Kappa
  .BionicBunion:/msg $chan BionicBunion
  .SwiftRage:/msg $chan SwiftRage
  .DansGame:/msg $chan DansGame
  .PJSalt:/msg $chan PJSalt
  .BrainSlug:/msg $chan BrainSlug
  .MVGame:/msg $chan MVGame
  .BCWarrior:/msg $chan BCWarrior
  .MrDestructoid:/msg $chan MrDestructoid
  .PicoMause:/msg $chan PicoMause
  .JonCarnage:/msg $chan JonCarnage
  .StrawBeary:/msg $chan StrawBeary
  .GingerPower:/msg $chan GingerPower
  .SuperVinlin:/msg $chan SuperVinlin
  .SMSkull:/msg $chan SMSkull
  .SMOrc:/msg $chan SMOrc
  JTV Emoticons 2
  .NoNoSpot:/msg $chan NoNoSpot
  .BlargNaut:/msg $chan BlargNaut
  .SoBayed:/msg $chan SoBayed
  .KevinTurtle:/msg $chan KevinTurtle
  .FreakinStinkin:/msg $chan FreakinStinkin
  .Kreygasm:/msg $chan Kreygasm
  .NinjaTroll:/msg $chan NinjaTroll
  .FPSMarksman:/msg $chan FPSMarksman
  .SSSsss:/msg $chan SSSsss
  .PunchTrees:/msg $chan PunchTrees
  .UleetBackup:/msg $chan UleetBackup
  .ArsonNoSexy:/msg $chan ArsonNoSexy
  .TehFunrun:/msg $chan TehFunrun
  .Smiley:/msg $chan :)
  .Frown:/msg $chan :(
  .Tongue:/msg $chan :p
  .Smirk:/msg $chan ;p
  .R):/msg $chan R)
  .B):/msg $chan B)
  .>(:/msg $chan .>(
  .OpenMouth:/msg $chan :0
  .<3:/msg $chan <3
  .O_o:/msg $chan O_o
  .Confuzzled:/msg $chan :z
  .;):/msg $chan ;)
}
