;****************************************************
;
;         JTV IRC Channel Control Script v 1.1
;            Dialog Event Handler Script
;                2011 Jennifer Snow
;
;****************************************************
;
;  The JTV IRC Channel Control Script was created to
;  allow JTV broadcasters who wish to use the IRC 
;  interface an easy to use interface to the dot and
;  slash commands available on jtv's irc server.
;
;****************************************************
;
;  Feedback is always welcomed, and right now is 
;  being requested for more features/bugfixing.
;
;****************************************************
;
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.
;  
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
;  
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;****************************************************
;
;*****************************************
; Main Dialog Event Handlers
;*****************************************

; Catch and parse all the events for the main dialog
on *:dialog:jtvirc.main:*:*: { 
  goto $devent
  ; the ACTIVE event is undocumented.  It is called when the window
  ; gains or loses focus (I think).  The other events we trap so 
  ; we dont see tons (literally) of : * /goto: 'mouse' not found (line 34, PsiFur2.events.mrc)
  :MOUSE | :UCLICK | :DCLICK | :RCLICK | :ACTIVE | :DROP | h
  :INIT  
    ; get ON / OFF status for toggles
    did $iif($jtvirc.hash(autoad) == 1,-c,-u) $dname 33
    did $iif($jtvirc.hash(slowmode) == 1,-c,-u) $dname 40
    did $iif($jtvirc.hash(friendsonly) == 1,-c,-u) $dname 42
    did $iif($jtvirc.hash(followersonly) == 1,-c,-u) $dname 43
    did $iif($jtvirc.hash(autoupdate) == 1,-c,-u) $dname 100

    ; Get the stream title history list
    did -r $dname 8
    did -a $dname 8 $jtvirc.hash(title)
    did -c $dname 8 1
    
    ; Now get the slowtime setting, and channel name
    did -r $dname 2
    did -a $dname 2 $jtvirc.hash(channel)

    did -r $dname 41
    did -a $dname 41 $jtvirc.hash(slowtime)

    ; Get autorun commercial time
    did -r $dname 34
    did -a $dname 34 $jtvirc.hash(autoadtime)

  :CLOSE | :EDIT
    ; When the dialog is closed or edited, we want to save the hashtable so that
    ; it will load up with the same settings
    ; save channel name
    $jtvirc.hash(channel,$did(2)).set

    ; save slow time value
    $jtvirc.hash(slowtime,$did(41)).set
    
    ; save auto commercial time
    $jtvirc.hash(autoadtime,$did(34)).set

    ; save toggles
    $jtvirc.hash(autoad,$did(40).state).set
    $jtvirc.hash(slowmode,$did(40).state).set
    $jtvirc.hash(friendsonly,$did(42).state).set
    $jtvirc.hash(followersonly,$did(43).state).set
    $jtvirc.hash(autoupdate,$did(100).state).set
    
    ; save title setting
    $jtvirc.hash(title,$did(8)).set

    ; save settings
    $jtvirc.savehashtable | h
  
  :SCLICK | :MENU | goto $did

    ;***************
    ; Options
    ;***************
    ; unused stuff... ICON image, form itself, labels, menu breaks, etc
    :0 | :3 | :4 | h

    ;*****************************************
    ; Title setting
    ;*****************************************
    :7
      ; Set channel title
      /msg $jtvirc.hash(channel) .title $jtvirc.hash(title)
      
      ; update channel viewers with new title
      /msg $jtvirc.hash(channel) Title changed to $+(",$jtvirc.hash(title),")
      
      ; Save new title to prior title list
;      $jtvirc.hash

      ; halt processing 
      h

    ;*****************************************
    ; Commercial Event Handlers
    ;*****************************************
    :30
      if (%jtvirc.ads == 1) {
        jtvirc.dlg jtvirc.commercial.timer.active jtvirc.commercial.timer.active 47 jtvirc.mrc
        
        ; halt processing 
        h
      }

      if ($me isop $jtvirc.hash(channel)) {
        set %jtvirc.ads 1
        .timer.jtvirc.Ads 1 30 set %jtvirc.ads 0
        /msg $jtvirc.hash(channel) .commercial
      }

      ; Halt further processing
      h

    :31
      if (%jtvirc.ads == 1) {
        jtvirc.dlg jtvirc.commercial.timer.active jtvirc.commercial.timer.active 47 jtvirc.mrc
        
        ; halt processing 
        h
      }

      if ($me isop $jtvirc.hash(channel)) {
        set %jtvirc.ads 1
        .timer.jtvirc.Ads 1 60 set %jtvirc.ads 0
        /msg $jtvirc.hash(channel) .commercial
        .timer 1 30 /msg $jtvirc.hash(channel) .commercial
      }

      ; Halt further processing
      h
    
    :32
      if (%jtvirc.ads == 1) {
        jtvirc.dlg jtvirc.commercial.timer.active jtvirc.commercial.timer.active 47 jtvirc.mrc
        
        ; halt processing 
        h
      }

      if ($me isop $jtvirc.hash(channel)) {
        set %jtvirc.ads 1
        .timer.jtvirc.Ads 1 90 set %jtvirc.ads 0
        /msg $jtvirc.hash(channel) .commercial
        .timer 2 30 /msg $jtvirc.hash(channel) .commercial
      }

      ; Halt further processing
      h

    ;*****************************************
    ; Autorun Commercial
    ;*****************************************
    :33
      if ($me isop $jtvirc.hash(channel)) {
        ; Change minutes entered into seconds
        var %jtvirc.autoadtime $calc($did(34) * 60)

        ; if the autoad is not running, start it
        if ($did(33).state == 1) {
          .timer.jtvirc.AutoAd 0 %jtvirc.autoadtime /msg $jtvirc.hash(channel) .commercial
        }
        
        ; otherwise stop it
        else {
          .timer.jtvirc.AutoAd off
        }
      }

      ; Halt further processing
      h

    ;*******************
    ; Slow Mode Toggle
    ;*******************
    :40
      ; make sure the user is an op in the channel
      if ($me isop $jtvirc.hash(channel)) {
        ; if slow mode is off, turn it on
        if ($did(40).state == 1) {
          /msg $jtvirc.hash(channel) .slow $jtvirc.hash(slowtime)
        }
        
        ; otherwise turn it off
        else {
          /msg $jtvirc.hash(channel) .slowoff
        }
      }

      ; Halt further processing
      h

    ;*******************
    ; Friends Only Toggle
    ;*******************
    :42
      ; make sure the user is an op in the channel
      if ($me isop $jtvirc.hash(channel)) {
        ; if slow mode is off, turn it on
        if ($did(42).state == 1) {
          /msg $jtvirc.hash(channel) .friends
        }
        
        ; otherwise turn it off
        else {
          /msg $jtvirc.hash(channel) .friendsoff
        }
      }

      ; Halt further processing
      h

    ;*******************
    ; Followers Only Toggle
    ;*******************
    :43
      ; make sure the user is an op in the channel
      if ($me isop $jtvirc.hash(channel)) {
        ; if followers only mode is off, turn it on
        if ($did(43).state == 1) {
          /msg $jtvirc.hash(channel) .followers
        }
        
        ; otherwise turn it off
        else {
          /msg $jtvirc.hash(channel) .followersoff
        }
      }

      ; Halt further processing
      h

    ;*******************
    ; Display Viewer Count
    ;*******************
    :44
      ; make sure the user is an op in the channel
      if ($me isop $jtvirc.hash(channel)) {
        ; send message to JTV requesting viewer count
        /msg $jtvirc.hash(channel) .viewers
      }

      ; Halt further processing
      h

    ;*******************
    ; Clear Chat
    ;*******************
    :45
      ; make sure the user is an op in the channel
      if ($me isop $jtvirc.hash(channel)) {
        ; send message to JTV requesting viewer count
        /msg $jtvirc.hash(channel) .clear
      }

      ; Halt further processing
      h
      
    ;*******************
    ; Manually Timeout User
    ;*******************
    :51
      if ($me isop $jtvirc.hash(channel)) {
        ; send message to JTV to timeout specified user
        /msg $jtvirc.hash(channel) .timeout $did(50) $did(52)
        
        ; display who was timed out, and for how long
        /msg $jtvirc.hash(channel) Timed out $did(50) for $did(52) seconds.

        ; and display funny timeout/ban quip
        set %jtvirc.UserTOd $did(50)
        $jtvirc.RandomTOStatement

      }

      h

    ;*******************
    ; Manually Ban User
    ;*******************
    :61
      if ($me isop $jtvirc.hash(channel)) {
        ; send message to JTV to timeout specified user
        /msg $jtvirc.hash(channel) .ban $did(60)
        
        ; display who was timed out, and for how long
        /msg $jtvirc.hash(channel) Banned $did(60) permanently.

;        ; and display funny timeout/ban quip
;        set %jtvirc.UserBanned $did(60)
;        $jtvirc.RandomTOStatement

      }

      h

    ;*******************
    ; Manually Unban User
    ;*******************
    :62
      if ($me isop $jtvirc.hash(channel)) {
        ; send message to JTV to timeout specified user
        /msg $jtvirc.hash(channel) .unban $did(60)

        ; display who was timed out, and for how long
        /msg $jtvirc.hash(channel) unbanned $did(60) $+ .
        
;        ; and display funny unban quip
;        set %jtvirc.UserUnBanned $did(60)
;        $jtvirc.RandomTOStatement

      }

      h

    ;*******************
    ; Auto-update Toggle
    ;*******************
    :100 | $jtvirc.hash(autoupdate,$did(100).state).set | h
    
    ;***************
    ; File Menu
    ;***************
    ; check for updates.
    :550 | jtvirc.checkversion | h
  
    ; unload... dear god NO!!!
    :552 
      jtvirc.closeDialog
      jtvirc.savehashtable
      .unload -rs $+(",$scriptdir,jtvirc.mrc,")
      h

    ; exit the dialogs - all of them
    :554
      jtvirc.closeDialog | h

    ;***************
    ; Help Menu
    ;***************
    ; Show Help Contents
    ; *** TODO ***
    ; I need to finish creating the HELP file.  TODO
    :751
      ; if ($isfile($scriptdir $+ jtvirc.hlp)) { run jtvirc.hlp } | h
      jtvirc.Help | h

    ; Open the website
    :753 | .run http://scripting.catreina.com | h
  
    ; show the about dialog
    ; *** TODO ***
    ; I need to create the actual ABOUT dialog.  It is currently EMPTY
    :756  ; jtvirc.dlg jtvirc.about jtvirc.about $scriptline jtvirc.events,mrc | h
}
