;****************************************************
;
;         JTV IRC Channel Control Script v 1.1
;            Commands and Aliases Script
;                2011 Jennifer Snow
;
;****************************************************
;
;  The JTV IRC Channel Control Script was created to
;  allow JTV broadcasters who wish to use the IRC 
;  interface an easy to use interface to the dot and
;  slash commands available on jtv's irc server.
;
;****************************************************
;
;  Feedback is always welcomed, and right now is 
;  being requested for more features/bugfixing.
;
;****************************************************
;
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.
;  
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
;  
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;****************************************************
;
;*********************
;  halt alias
;*********************

; allows use of 'h' to stop script execution
alias h halt

;*********************
; DLL/MDX Aliases
;*********************
;
; These also have an advantage... the jtvirc.loaddll function checks
;   that the dll is actually present, and returns an error if it is not.

alias jtvirc.mdx { return $jtvirc.getdll(mdx.dll,$scriptline,jtvirc.commands.mrc) }
alias jtvirc.ctl { return $jtvirc.getdll(ctl_gen.mdx,$scriptline,jtvirc.commands.mrc) }

alias jtvirc.mdxload {
  var %x = $dll($jtvirc.mdx,SetMircVersion,$version)
  var %x = $dll($jtvirc.mdx,MarkDialog,$dname)
}

;*********************
; DLL Pathing routine
;*********************
alias -l jtvirc.getdll {
  if (!$isfile($+($scriptdir,dlls\,$1))) {
    jtvirc.displayerror $2 $3- File Not Found: $1
  }
  else {
    return $+(",$scriptdir,dlls\,$1,")
  }
}

;*********************
; DLL Release
;*********************
jtvirc.unloaddll {
  dll -u $1-
}

;*********************
; Variable Setting
;*********************
alias jtvirc.setvars {
  set %jtvirc.version 1.1
  set %jtvirc.releasedate December 28, 2011
  set %jtvirc.hashfile $+(",$scriptdirjtvirc.hash,")
  set %jtvirc.default.hash $+(",$scriptdirjtvirc.default.hash,")
}

;*********************
; Dialog creation
;*********************
alias jtvirc.dlg {
  if ((!$3) || (!$4)) { mIRCSplit.displayerror $1 $2 Invalid dialog parameters! }
  if ($dialog($1) != $2) {
    dialog -drvm $1 $2
  }
  else {
    dialog -v $1
  }      
}

;*********************
; Message display
;*********************
alias jtvirc.Display {
  ; if the window was shut, reopen it to display messages
  if ( $window(@jtvirc.Messages) != @jtvirc.Messages ) {
    .window -exzk0 +eltx @jtvirc.Messages 
  }    
  .aline $1 @jtvirc.Messages *** $2- 
}

;*********************
; Error display
;*********************
alias jtvirc.displayerror { 
  if %jtvirc.DebugWindow {
    jtvirc.Display 4 jtvirc script halted. $3- (Line $1 in file $2 $+ )
  } 
  else {
    echo 4 -st *** jtvirc script halted. $3- (Line $1 in file $2 $+)
  }

  if ($dialog(jtvirc.main)) dialog -x jtvirc.main

  if ($dialog(0) > 0) {
    var %y = $dialog(0)
    while (%y > 0) { 
      dialog -x $dialog(%y) 
      dec %y
    }
  }
  halt
}

;*********************
; Hashtable commands
;*********************
alias jtvirc.loadhashtable {
  ;First, check if our hashtable exists, and if not, create it
  if (!$hget(jtvirc.hashtable)) { hmake jtvirc.hashtable 25 }

  ; We check for a user defined hashfile. If we dont find one, 
  ; we want to use a default settings file, which is provided
  ; with the distribution
  ; if both files are missing, start empty
  if ($isfile(%jtvirc.hashfile)) {
    ;the hash file exists, fill the hashtable
    hload jtvirc.hashtable %jtvirc.hashfile
  }
  elseif ($isfile(%jtvirc.default.hash)) {
    ; load the defaults.  The main hashfile is missing
    hload jtvirc.hashtable %jtvirc.default.hash
  }
  else {
    ; no default hashfile, no main hashfile, set defaults manually
    
    ; set debug window usage
    $jtvirc.hash(debugwindow,1).set
    
    ; set auto-update usage
    $jtvirc.hash(autoupdate,1).set

    ; save slowmode setting
    $jtvirc.hash(slowmode,0).set

    ; save default stream title
    $jtvirc.hash(title,Welcome to my stream!).set
  
  }    
}

alias jtvirc.savehashtable {
  ;save all our hashtable information to our hashfile
  hsave -o jtvirc.hashtable %jtvirc.hashfile
}

alias jtvirc.hash {
  if (($prop == set) || ($prop == add)) {
    ;add a hashtable entry
    var %jtvirc.varname = $1
    var %jtvirc.vardata = $2-
    hadd -m jtvirc.hashtable %jtvirc.varname %jtvirc.vardata
  }
  elseif ($prop == get) || (!$prop) {
    ;get a hashtable entry
    return $hget(jtvirc.hashtable,$1)
  }
}


;*********************
; Close all dialogs
;*********************

alias jtvirc.closeDialog {
  if ($dialog(0) > 0) {
    var %jtvirc.y = $dialog(0)
    while (%jtvirc.y > 0) {
      if (jtvirc.* iswm $dialog(%jtvirc.y)) {
        ; it is one of our dialogs. close it
        dialog -x $dialog(%jtvirc.y)
      }
      dec %jtvirc.y
    }
  }
}

;****************************************************
; Help
;
; Displays the stuff that can confuse for now.
; In the next revision, mIRCSplit will have a fairly 
; extensive Windows Help file included.
;

alias jtvirc.Help {
  if ( $window(@jtvirc.Messages) != @jtvirc.Messages ) {
    .window -exzk0 +eltx @jtvirc.Messages 
  }    

  .aline 6 @jtvirc.Messages  jtvirc v $+ %jtvirc.version HELP
  .aline 6 @jtvirc.Messages  released %jtvirc.releasedate
  .aline 6 @jtvirc.Messages -
  .aline 6 @jtvirc.Messages - Options dialog
  .aline 6 @jtvirc.Messages --- To Be Created
  .aline 6 @jtvirc.Messages ----- ?????
}

