;****************************************************
;
;         JTV IRC Channel Control Script v 1.1
;                Auto-updater Script
;                2011 Jennifer Snow
;
;****************************************************
;
;  The JTV IRC Channel Control Script was created to
;  allow JTV broadcasters who wish to use the IRC 
;  interface an easy to use interface to the dot and
;  slash commands available on jtv's irc server.
;
;****************************************************
;
;  Feedback is always welcomed, and right now is 
;  being requested for more features/bugfixing.
;
;****************************************************
;
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.
;  
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
;  
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;****************************************************
;

;*********************
; Progress bar
;*********************
dialog jtvirc.autoupdate {
  title Updating JTV IRC to $+(v,%jtvirc.newver)
  size -1 -1 175 12
  option dbu
  text "", 1, 0 0 175 12
}

;*********************
; Progress bar init
;*********************
on *:dialog:jtvirc.autoupdate:init:0: {
  jtvirc.mdxload
  var %x = $dll($scriptdirdlls\mdx.dll,SetControlMDX,$dname 1 ProgressBar smooth > $scriptdirdlls\ctl_gen.mdx)
}

;*********************
; Progress updater
;*********************
; the download portion is about 25% of the whole update.  The rest is replacing files and DLL's
alias -l jtvirc.autoupdate.download.update  {
  .did -a jtvirc.autoupdate 1 $gettok($calc(100 * ($sock($sockname).rcvd - %jtvirc.downloadoffset) / %jtvirc.downloadlength),1,46) 0 100
  return 0
}

; File replacement. This is about 75% of the update process.
alias -l jtvirc.autoupdate.unzip.update  {
  .did -a jtvirc.autoupdate 1 $gettok($calc(100 * ($sock($sockname).rcvd - %jtvirc.downloadoffset) / %jtvirc.downloadlength),1,46) 0 100
  return 0
}

;*********************
; New Version Check
;*********************
alias jtvirc.checkversion {
  if ( $sock( jtvirc.updatecheck ) ) { sockclose jtvirc.updatecheck }
  sockopen jtvirc.checkversion scripting.catreina.com 80
  if %jtvirc.DebugWindow {
    jtvirc.Display 6 Checking JTV IRC version against latest release...
  }
}

on *:SOCKOPEN:jtvirc.checkversion:{
  var %ticks $ticks
  while ( $sock( jtvirc.checkversion ).status != Active ) { 
    if ($calc($ticks - %ticks) > 10000) {
      sockclose jtvirc.checkversion
      if %jtvirc.DebugWindow {
        jtvirc.Display 4 Socket Error: No Response from http://scripting.catreina.com - Please try again later.
      }
      else {
        echo 4 -at Socket Error: No Response from http://scripting.catreina.com - Please try again later.
      }
      return
    }
  }
  sockwrite -n $sockname GET / HTTP/1.0
  sockwrite -n $sockname Accept: */*
  sockwrite -n $sockname Host: scripting.catreina.com
  sockwrite -n $sockname
}

on *:SOCKREAD:jtvirc.checkversion:{
  var %tmp
  sockread %tmp

  if (%tmp == $null) { return }

  if ( jtvirc_VERSION isin %tmp ) {
    ; should return #.#
    set %jtvirc.newver $gettok(%tmp,2,32) 

    if (( %jtvirc.newver < %jtvirc.version ) || ( %jtvirc.newver == %jtvirc.version )) {
      if %jtvirc.DebugWindow {
        jtvirc.Display 6 JTV IRC does not need to be updated
      }
      sockclose jtvirc.checkversion
      return
    }
    else {
      ; the script has found an update.
      set %jtvirc.getupdate true
    }      
  }

  if ( %jtvirc.getupdate == true ) {
    if ( jtvirc_RELEASEDATE isin %tmp ) {
      set %jtvirc.update.releasedate $gettok(%tmp,2,32) 
    }
    elseif ( jtvirc_AUTHOR isin %tmp ) {
      set %jtvirc.update.author $gettok(%tmp,2,32) 
    }
    elseif ( jtvirc_PATH isin %tmp ) {
      set %jtvirc.update.path $gettok(%tmp,2,32) 
    }
    elseif ( jtvirc_FILE isin %tmp ) {
      set %jtvirc.update.file $gettok(%tmp,2,32) 
    }
    elseif ( END jtvirc HEADER isin %tmp ) {
    ;  if (( %jtvirc.getupdate == true ) && (jtvirc.hash(autoupdate).get == 1)) {
      if ( %jtvirc.getupdate == true ) {
        ; if the auto-update switch is on, then auto update
        if ($jtvirc.hash(autoupdate) == 1) {
          $jtvirc.update
        }
        ; otherwise, prompt to download and install
        else {
          .timer -om 1 5 { jtvirc.DownloadAvailableUpdate }
        }
      }
    }
  }
}

alias jtvirc.DownloadAvailableUpdate {
  if ($input(JTV IRC Version %jtvirc.newver is available. Download and install the update?,ydq,Update JTV IRC?)) {
    if %jtvirc.DebugWindow {
      jtvirc.Display 6 JTV IRC updating...
    }
    ; unload all dialogs
    jtvirc.closeDialog
    
    ; Launch the updater
    $jtvirc.update
  }
  else {
    if %jtvirc.DebugWindow {
      jtvirc.Display 6 JTV IRC NOT updating.  Please visit http://scripting.catreina.com to manually update to version %jtvirc.newver
    }
  }
}

;*********************
; Start the Update
;*********************
alias jtvirc.update {

  if %jtvirc.DebugWindow {
    jtvirc.Display 6 Downloading JTV IRC update (Version %jtvirc.newver $+ )
  }

  if ($sock(jtvirc.socket)) {
    if %jtvirc.DebugWindow {
      jtvirc.Display 4 JTV IRC $+(v,%jtvirc.newver) currently downloading.
    }
    else {
      echo 4 -st JTV IRC $+(v,%jtvirc.newver) currently downloading.
    }
    return
  }

  ; connect to server
  sockopen jtvirc.socket scripting.catreina.com 80
}

;*********************
; DL Socket open
;*********************
on *:sockopen:jtvirc.socket:{
  if ($sockerr) {
    if %jtvirc.DebugWindow {
      jtvirc.Display 4 During download: $sockerr - download aborted
    }
    else {
      echo 4 -as *** During download: $sockerr - download aborted
    }
    return
  }

  if $isfile($+(",$scriptdir,%jtvirc.update.file,")) { .remove $+(",$scriptdir,%jtvirc.update.file,") }
  write -c $+(",$scriptdir,%jtvirc.update.file,")
  unset %jtvirc.downloadlength %jtvirc.downloadready

  ; request file
  sockwrite -n $sockname GET $+(%jtvirc.update.path,%jtvirc.update.file) HTTP/1.0
  sockwrite -n $sockname Accept: */*
  sockwrite -n $sockname Host: scripting.catreina.com
  sockwrite -n $sockname
}

;*********************
; DL Socket read
;*********************
on *:sockread:jtvirc.socket:{

  ; if we're not ready to start writing the file (didn't get header info yet)..
  if (%jtvirc.downloadready != 1) {

    ; begin reading header info
    var %jtvirc.header
    sockread %jtvirc.header

    while ($sockbr) {
      ; make sure that the file we are attempting to get is there!
      if (* 404 Object Not Found iswm %jtvirc.header) { 
        ; file wasnt found.  Set a trigger to NOT contiue .. halt isnt working
        set %jtvirc.finalizeupdate false
        jtvirc.displayerror $scriptline jtvirc.autoupdate.mrc File not found: %jtvirc.update.file
      }
      
      if (Content-length: * iswm %jtvirc.header) {

        ; got the length of the file
        %jtvirc.downloadlength = $gettok(%jtvirc.header,2,32)
      }
      elseif (* !iswm %jtvirc.header) {

        ; got the header info, ready..
        %jtvirc.downloadready = 1

        ; because we've received some bytes from the header.. we need to offset the progress counter a bit.
        %jtvirc.downloadoffset = $sock($sockname).rcvd

        ; got the file info, open progress bar
        jtvirc.dlg jtvirc.autoupdate jtvirc.autoupdate $scriptline jtvirc.autoupdate.mrc

        ; ready to download, got content length.. so break out of this header loop
        break
      }
      sockread %jtvirc.header
    }
  }
  ; begin binary download
  sockread 4096 &d

  while ($sockbr) {

    ; call our progress bar updater 
    .timerjtvirc.downloadtimer -om 1 $calc(100 / $calc(%jtvirc.downloadlength - %jtvirc.downloadoffset)) $jtvirc.autoupdate.download.update

    ; write the data to the end of the file
    bwrite $+(",$scriptdir,%jtvirc.update.file,") -1 -1 &d

    ; read the next bit
    sockread 4096 &d
  }
  .timerjtvirc.downloadtimer off
  %jtvirc.finalizeupdate = true
}

;*********************
; DL Socket read
;*********************
on *:sockclose:jtvirc.socket:{

  ; close progress bar
  if ($dialog(jtvirc.autoupdate)) dialog -x jtvirc.autoupdate

  ; verify that the file was downloaded
  if ($isfile($+(",$scriptdir,%jtvirc.update.file,"))) {
    if (%jtvirc.finalizeupdate == true) {

      ; load the "jtvirc.update.mrc" file. 
      .load -rs $+(",$scriptdir,jtvirc.update.mrc,")
 
      ; finally, call the jtvirc.installupdate alias
      jtvirc.installupdate %jtvirc.newver $scriptdir $+ %jtvirc.update.file
    }
  }
}
